;==============================================================================;
;== bootloader.inc									Last Update 2018/04/03
;==	pic16f145x_family										Saka Softwares
;==============================================================================;
;== Define ====================================================================;
;==	ユーザープログラム開始アドレス設定 (1つを選択する)
	#define BOOTLOADER_CUSTOM	; スタートアドレス 0x0500 (純正のVer1.02 対応)
;;	#define BOOTLOADER_ORIGINAL	; スタートアドレス 0x9000 (純正のVer1.02対応 同一アドレス)
;==============================================================================;
#ifdef _HID_BOOTLOADER
	extern	Main_Reset				; main.asm
#else
	extern	BootlodarInit			; ブートローダー初期化
	extern	BootlodarTasks			; ブートローダー実行部
#endif
;== Vector remapping ==========================================================;
#ifdef	 BOOTLOADER_CUSTOM
	#define APP_SIGNATURE_ADDRESS		0x500	; ブートサインアドレス
	#define APP_VERSION_ADDRESS			0x502	; アプリ用バージョンアドレス
	#define REMAPPED_RESET_VECTOR		0x504	; アプリ用リセットアドレス
	#define REMAPPED_ISR_VECTOR			(REMAPPED_RESET_VECTOR + 0x004)	; アプリ用高割り込みアドレス
#endif
#ifdef	 BOOTLOADER_ORIGINAL
	#define APP_SIGNATURE_ADDRESS		0x900	; ブートサインアドレス
	#define APP_VERSION_ADDRESS			0x902	; アプリ用バージョンアドレス
	#define REMAPPED_RESET_VECTOR		0x904	; アプリ用リセットアドレス
	#define REMAPPED_ISR_VECTOR			(REMAPPED_RESET_VECTOR + 0x004)	; アプリ用高割り込みアドレス
#endif
	#define BOOTLOADER_ENTRY_ADDRESS	0x001C	; ブートローダーエントリーアドレス
	#define APP_SIGNATURE_VALUE			0x6D	; ブートサインコード
	#define	RETLW_OPCODE_MSB			0x34	; retlwのOPコード
	#define	BLANK_FLASH_WORD_VALUE		0x3FFF	; ブランク時のコード

	#define APP_SIGN_ADRL				0x00
	#define APP_SIGN_ADRH				0x01	; リセットアドレスから相対位置
	#define APP_VER_ADRL				0x02
	#define APP_VER_ADRH				0x03	; リセットアドレスから相対位置

;== end of file ===============================================================;
